/*
 * Decompiled with CFR 0.152.
 */
package com.cybanetix.calm.DBExport;

import com.cybanetix.calm.DBExport.config.Config;
import com.cybanetix.calm.DBExport.config.StateField;
import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main {
    private static final Logger logger = LogManager.getLogger(Main.class);

    public static void main(String[] args) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Config c2 = null;
        try {
            c2 = objectMapper.readValue(new File(args[0]), Config.class);
        }
        catch (StreamReadException e1) {
            e1.printStackTrace();
            System.exit(1);
        }
        catch (DatabindException e1) {
            e1.printStackTrace();
            System.exit(1);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            System.exit(1);
        }
        String query = Main.buildQuery(c2);
        try (Connection conn = DriverManager.getConnection(c2.db_url, c2.db_user, c2.db_pass);
             PreparedStatement stmt = conn.prepareStatement(query);){
            for (int i2 = 0; i2 < c2.stateFields.size(); ++i2) {
                StateField f2 = c2.stateFields.get(i2);
                try {
                    switch (f2.type) {
                        case "int": {
                            stmt.setInt(i2 + 1, Main.getStateInt(c2, f2));
                            break;
                        }
                        case "long": {
                            stmt.setLong(i2 + 1, Main.getStateLong(c2, f2));
                            break;
                        }
                        case "date": {
                            stmt.setTimestamp(i2 + 1, Main.getStateDate(c2, f2));
                        }
                    }
                    continue;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    System.exit(1);
                }
            }
            ResultSet rs = stmt.executeQuery();
            Date now = new Date();
            String filename = String.format("%s%s%04d-%02d-%02dT%02d:%02d:%02d.log", c2.outDir, File.separator, now.getYear() + 1900, now.getMonth(), now.getDay(), now.getHours(), now.getMinutes(), now.getSeconds());
            FileWriter csvWriter = new FileWriter(filename);
            while (rs.next()) {
                ArrayList<String> columns = new ArrayList<String>();
                for (String string : c2.db_query.fields) {
                    columns.add(rs.getString(string));
                }
                csvWriter.append(String.join((CharSequence)",", columns)).append("\n");
                if (!rs.isLast()) continue;
                for (StateField stateField : c2.stateFields) {
                    FileOutputStream stateWriter = new FileOutputStream(c2.stateDir + File.separator + stateField.field);
                    switch (stateField.type) {
                        case "int": {
                            stateWriter.write(rs.getBytes(stateField.field));
                            break;
                        }
                        case "long": {
                            stateWriter.write(rs.getBytes(stateField.field));
                            break;
                        }
                        case "date": {
                            stateWriter.write(rs.getTimestamp(stateField.field).toString().getBytes());
                        }
                    }
                    stateWriter.close();
                }
            }
            csvWriter.flush();
            csvWriter.close();
        }
        catch (SQLException e3) {
            System.out.println(e3.getMessage());
            e3.printStackTrace();
        }
    }

    private static Timestamp getStateDate(Config c2, StateField f2) {
        File file = new File(c2.stateDir + File.separator + f2.field);
        Timestamp d2 = new Timestamp(0L);
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(file));
            long size = file.length();
            byte[] data = new byte[(int)size];
            dis.readFully(data);
            String state = new String(data);
            logger.info("Got state: " + f2.field + "/" + state);
            d2 = Timestamp.valueOf(state);
            dis.close();
        }
        catch (IOException e2) {
            logger.info(e2);
        }
        return d2;
    }

    private static int getStateInt(Config c2, StateField f2) {
        File file = new File(c2.stateDir + File.separator + f2.field);
        int d2 = 0;
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(file));
            d2 = dis.readInt();
            dis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.info("Got state: " + f2.field + "/" + d2);
        return d2;
    }

    private static long getStateLong(Config c2, StateField f2) throws IOException {
        File file = new File(c2.stateDir + File.separator + f2.field);
        long d2 = 0L;
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(file));
            d2 = dis.readLong();
            dis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.info("Got state: " + f2.field + "/" + d2);
        return d2;
    }

    private static String buildQuery(Config c2) {
        StringBuilder query = new StringBuilder();
        ArrayList<String> stateCompare = new ArrayList<String>();
        ArrayList<String> orderByList = new ArrayList<String>();
        for (int i2 = 0; i2 < c2.stateFields.size(); ++i2) {
            StateField field = c2.stateFields.get(i2);
            if (i2 + 1 == c2.stateFields.size()) {
                stateCompare.add(field.field + " > ?");
            } else {
                stateCompare.add(field.field + " >= ?");
            }
            orderByList.add(field.field);
        }
        query.append("SELECT `");
        query.append(String.join((CharSequence)"`, `", c2.db_query.fields)).append("` FROM ");
        query.append(String.join((CharSequence)", ", c2.db_query.tables)).append(" WHERE ");
        query.append("(");
        query.append(String.join((CharSequence)" AND ", stateCompare));
        query.append(")");
        if (c2.db_query.where_clause != null) {
            query.append(" AND (").append(c2.db_query.where_clause).append(")");
        }
        query.append(" ORDER BY (").append(String.join((CharSequence)", ", orderByList)).append(")");
        String str = query.toString();
        logger.info("Building SQL Query: " + str);
        return str;
    }
}

