/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerClobBase;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;

final class SQLServerClobAsciiOutputStream
extends OutputStream {
    private SQLServerClobBase parentClob = null;
    private long streamPos;
    private byte[] bSingleByte = new byte[1];

    SQLServerClobAsciiOutputStream(SQLServerClobBase parentClob, long streamPos) {
        this.parentClob = parentClob;
        this.streamPos = streamPos;
    }

    @Override
    public void write(byte[] b2) throws IOException {
        if (null == b2) {
            return;
        }
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (null == b2) {
            return;
        }
        try {
            String s2 = new String(b2, off, len, StandardCharsets.US_ASCII);
            int charsWritten = this.parentClob.setString(this.streamPos, s2);
            this.streamPos += (long)charsWritten;
        }
        catch (SQLException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public void write(int b2) throws IOException {
        this.bSingleByte[0] = (byte)(b2 & 0xFF);
        this.write(this.bSingleByte, 0, this.bSingleByte.length);
    }
}

