/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import com.microsoft.aad.msal4j.IntegratedWindowsAuthenticationParameters;
import com.microsoft.aad.msal4j.InteractiveRequestParameters;
import com.microsoft.aad.msal4j.MsalInteractionRequiredException;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.SilentParameters;
import com.microsoft.aad.msal4j.SystemBrowserOptions;
import com.microsoft.aad.msal4j.UserNamePasswordParameters;
import com.microsoft.sqlserver.jdbc.PersistentTokenCacheAccessAspect;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResource;
import com.microsoft.sqlserver.jdbc.SqlFedAuthToken;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.kerberos.KerberosPrincipal;

class SQLServerMSAL4JUtils {
    static final String REDIRECTURI = "http://localhost";
    private static final String SLASH_DEFAULT = "/.default";
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerMSAL4JUtils");

    SQLServerMSAL4JUtils() {
    }

    static SqlFedAuthToken getSqlFedAuthToken(SQLServerConnection.SqlFedAuthInfo fedAuthInfo, String user, String password, String authenticationString) throws SQLServerException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            PublicClientApplication pca = ((PublicClientApplication.Builder)((PublicClientApplication.Builder)PublicClientApplication.builder((String)"7f98cb04-cd1e-40df-9140-3bf7e2cea4db").executorService(executorService)).authority(fedAuthInfo.stsurl)).build();
            CompletableFuture future = pca.acquireToken(UserNamePasswordParameters.builder(Collections.singleton(fedAuthInfo.spn + SLASH_DEFAULT), (String)user, (char[])password.toCharArray()).build());
            IAuthenticationResult authenticationResult = (IAuthenticationResult)future.get();
            SqlFedAuthToken sqlFedAuthToken = new SqlFedAuthToken(authenticationResult.accessToken(), authenticationResult.expiresOnDate());
            return sqlFedAuthToken;
        }
        catch (InterruptedException | MalformedURLException e2) {
            Thread.currentThread().interrupt();
            throw new SQLServerException(e2.getMessage(), e2);
        }
        catch (ExecutionException e3) {
            throw SQLServerMSAL4JUtils.getCorrectedException(e3, user, authenticationString);
        }
        finally {
            executorService.shutdown();
        }
    }

    static SqlFedAuthToken getSqlFedAuthTokenPrincipal(SQLServerConnection.SqlFedAuthInfo fedAuthInfo, String aadPrincipalID, String aadPrincipalSecret, String authenticationString) throws SQLServerException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            String defaultScopeSuffix = SLASH_DEFAULT;
            String scope = fedAuthInfo.spn.endsWith(defaultScopeSuffix) ? fedAuthInfo.spn : fedAuthInfo.spn + defaultScopeSuffix;
            HashSet<String> scopes = new HashSet<String>();
            scopes.add(scope);
            IClientSecret credential = ClientCredentialFactory.createFromSecret((String)aadPrincipalSecret);
            ConfidentialClientApplication clientApplication = ((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)aadPrincipalID, (IClientCredential)credential).executorService(executorService)).authority(fedAuthInfo.stsurl)).build();
            CompletableFuture future = clientApplication.acquireToken(ClientCredentialParameters.builder(scopes).build());
            IAuthenticationResult authenticationResult = (IAuthenticationResult)future.get();
            SqlFedAuthToken sqlFedAuthToken = new SqlFedAuthToken(authenticationResult.accessToken(), authenticationResult.expiresOnDate());
            return sqlFedAuthToken;
        }
        catch (InterruptedException | MalformedURLException e2) {
            Thread.currentThread().interrupt();
            throw new SQLServerException(e2.getMessage(), e2);
        }
        catch (ExecutionException e3) {
            throw SQLServerMSAL4JUtils.getCorrectedException(e3, aadPrincipalID, authenticationString);
        }
        finally {
            executorService.shutdown();
        }
    }

    static SqlFedAuthToken getSqlFedAuthTokenIntegrated(SQLServerConnection.SqlFedAuthInfo fedAuthInfo, String authenticationString) throws SQLServerException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            KerberosPrincipal kerberosPrincipal = new KerberosPrincipal("username");
            String user = kerberosPrincipal.getName();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(logger.toString() + " realm name is:" + kerberosPrincipal.getRealm());
            }
            PublicClientApplication pca = ((PublicClientApplication.Builder)((PublicClientApplication.Builder)PublicClientApplication.builder((String)"7f98cb04-cd1e-40df-9140-3bf7e2cea4db").executorService(executorService)).authority(fedAuthInfo.stsurl)).build();
            CompletableFuture future = pca.acquireToken(IntegratedWindowsAuthenticationParameters.builder(Collections.singleton(fedAuthInfo.spn + SLASH_DEFAULT), (String)user).build());
            IAuthenticationResult authenticationResult = (IAuthenticationResult)future.get();
            SqlFedAuthToken sqlFedAuthToken = new SqlFedAuthToken(authenticationResult.accessToken(), authenticationResult.expiresOnDate());
            return sqlFedAuthToken;
        }
        catch (IOException | InterruptedException e2) {
            Thread.currentThread().interrupt();
            throw new SQLServerException(e2.getMessage(), e2);
        }
        catch (ExecutionException e3) {
            throw SQLServerMSAL4JUtils.getCorrectedException(e3, "", authenticationString);
        }
        finally {
            executorService.shutdown();
        }
    }

    static SqlFedAuthToken getSqlFedAuthTokenInteractive(SQLServerConnection.SqlFedAuthInfo fedAuthInfo, String user, String authenticationString) throws SQLServerException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            PublicClientApplication pca = ((PublicClientApplication.Builder)((PublicClientApplication.Builder)((PublicClientApplication.Builder)((PublicClientApplication.Builder)PublicClientApplication.builder((String)"7f98cb04-cd1e-40df-9140-3bf7e2cea4db").executorService(executorService)).setTokenCacheAccessAspect((ITokenCacheAccessAspect)PersistentTokenCacheAccessAspect.getInstance())).authority(fedAuthInfo.stsurl)).logPii(logger.isLoggable(Level.FINE))).build();
            CompletableFuture future = null;
            IAuthenticationResult authenticationResult = null;
            try {
                IAccount account;
                Set accountsInCache = (Set)pca.getAccounts().join();
                if (null != accountsInCache && !accountsInCache.isEmpty() && null != user && !user.isEmpty() && null != (account = SQLServerMSAL4JUtils.getAccountByUsername(accountsInCache, user))) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(logger.toString() + "Silent authentication for user:" + user);
                    }
                    SilentParameters silentParameters = SilentParameters.builder(Collections.singleton(fedAuthInfo.spn + SLASH_DEFAULT), (IAccount)account).build();
                    future = pca.acquireTokenSilently(silentParameters);
                }
            }
            catch (MsalInteractionRequiredException accountsInCache) {
                // empty catch block
            }
            if (null != future) {
                authenticationResult = (IAuthenticationResult)future.get();
            } else {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(logger.toString() + "Interactive authentication");
                }
                InteractiveRequestParameters parameters = InteractiveRequestParameters.builder((URI)new URI(REDIRECTURI)).systemBrowserOptions(SystemBrowserOptions.builder().htmlMessageSuccess(SQLServerResource.getResource("R_MSALAuthComplete")).build()).loginHint(user).scopes(Collections.singleton(fedAuthInfo.spn + SLASH_DEFAULT)).build();
                future = pca.acquireToken(parameters);
                authenticationResult = (IAuthenticationResult)future.get();
            }
            SqlFedAuthToken sqlFedAuthToken = new SqlFedAuthToken(authenticationResult.accessToken(), authenticationResult.expiresOnDate());
            return sqlFedAuthToken;
        }
        catch (InterruptedException | MalformedURLException | URISyntaxException e2) {
            Thread.currentThread().interrupt();
            throw new SQLServerException(e2.getMessage(), e2);
        }
        catch (ExecutionException e3) {
            throw SQLServerMSAL4JUtils.getCorrectedException(e3, user, authenticationString);
        }
        finally {
            executorService.shutdown();
        }
    }

    private static IAccount getAccountByUsername(Set<IAccount> accounts, String username) {
        if (!accounts.isEmpty()) {
            for (IAccount account : accounts) {
                if (!account.username().equals(username)) continue;
                return account;
            }
        }
        return null;
    }

    private static SQLServerException getCorrectedException(ExecutionException e2, String user, String authenticationString) {
        Object[] msgArgs = new Object[]{user, authenticationString};
        if (null == e2.getCause() || null == e2.getCause().getMessage()) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_MSALExecution"));
            return new SQLServerException(form.format(msgArgs), null);
        }
        String correctedErrorMessage = e2.getCause().getMessage().replaceAll("\\\\r\\\\n", "\r\n").replaceAll("\\{", "\"").replaceAll("\\}", "\"");
        RuntimeException correctedAuthenticationException = new RuntimeException(correctedErrorMessage);
        MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_MSALExecution") + " " + correctedErrorMessage);
        ExecutionException correctedExecutionException = new ExecutionException(correctedAuthenticationException);
        return new SQLServerException(form.format(msgArgs), null, 0, (Throwable)correctedExecutionException);
    }
}

