/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.signedness;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.checkerframework.checker.signedness.qual.Unsigned;

public final class SignednessUtil {
    private SignednessUtil() {
        throw new Error("Do not instantiate");
    }

    public static ByteBuffer wrapUnsigned(@Unsigned byte[] array) {
        return ByteBuffer.wrap(array);
    }

    public static ByteBuffer wrapUnsigned(@Unsigned byte[] array, int offset, int length) {
        return ByteBuffer.wrap(array, offset, length);
    }

    public static @Unsigned int getUnsignedInt(ByteBuffer b2) {
        return b2.getInt();
    }

    public static @Unsigned short getUnsignedShort(ByteBuffer b2) {
        return b2.getShort();
    }

    public static @Unsigned byte getUnsigned(ByteBuffer b2) {
        return b2.get();
    }

    public static @Unsigned byte getUnsigned(ByteBuffer b2, int i2) {
        return b2.get(i2);
    }

    public static ByteBuffer getUnsigned(ByteBuffer b2, byte[] bs, int i2, int l2) {
        return b2.get(bs, i2, l2);
    }

    public static ByteBuffer putUnsigned(ByteBuffer b2, @Unsigned byte ubyte) {
        return b2.put(ubyte);
    }

    public static ByteBuffer putUnsigned(ByteBuffer b2, int i2, @Unsigned byte ubyte) {
        return b2.put(i2, ubyte);
    }

    public static IntBuffer putUnsigned(IntBuffer b2, @Unsigned int uint) {
        return b2.put(uint);
    }

    public static IntBuffer putUnsigned(IntBuffer b2, int i2, @Unsigned int uint) {
        return b2.put(i2, uint);
    }

    public static IntBuffer putUnsigned(IntBuffer b2, @Unsigned int[] uints) {
        return b2.put(uints);
    }

    public static IntBuffer putUnsigned(IntBuffer b2, @Unsigned int[] uints, int i2, int l2) {
        return b2.put(uints, i2, l2);
    }

    public static @Unsigned int getUnsigned(IntBuffer b2, int i2) {
        return b2.get(i2);
    }

    public static ByteBuffer putUnsignedShort(ByteBuffer b2, @Unsigned short ushort) {
        return b2.putShort(ushort);
    }

    public static ByteBuffer putUnsignedShort(ByteBuffer b2, int i2, @Unsigned short ushort) {
        return b2.putShort(i2, ushort);
    }

    public static ByteBuffer putUnsignedInt(ByteBuffer b2, @Unsigned int uint) {
        return b2.putInt(uint);
    }

    public static ByteBuffer putUnsignedInt(ByteBuffer b2, int i2, @Unsigned int uint) {
        return b2.putInt(i2, uint);
    }

    public static ByteBuffer putUnsignedLong(ByteBuffer b2, int i2, @Unsigned long ulong) {
        return b2.putLong(i2, ulong);
    }

    public static @Unsigned char readUnsignedChar(RandomAccessFile f2) throws IOException {
        return f2.readChar();
    }

    public static @Unsigned int readUnsignedInt(RandomAccessFile f2) throws IOException {
        return f2.readInt();
    }

    public static @Unsigned long readUnsignedLong(RandomAccessFile f2) throws IOException {
        return f2.readLong();
    }

    public static int readUnsigned(RandomAccessFile f2, @Unsigned byte[] b2, int off, int len) throws IOException {
        return f2.read(b2, off, len);
    }

    public static void readFullyUnsigned(RandomAccessFile f2, @Unsigned byte[] b2) throws IOException {
        f2.readFully(b2);
    }

    public static void writeUnsigned(RandomAccessFile f2, @Unsigned byte[] bs, int off, int len) throws IOException {
        f2.write(bs, off, len);
    }

    public static void writeUnsignedByte(RandomAccessFile f2, @Unsigned byte b2) throws IOException {
        f2.writeByte(Byte.toUnsignedInt(b2));
    }

    public static void writeUnsignedChar(RandomAccessFile f2, @Unsigned char c2) throws IOException {
        f2.writeChar(SignednessUtil.toUnsignedInt(c2));
    }

    public static void writeUnsignedShort(RandomAccessFile f2, @Unsigned short s2) throws IOException {
        f2.writeShort(Short.toUnsignedInt(s2));
    }

    public static void writeUnsignedInt(RandomAccessFile f2, @Unsigned int i2) throws IOException {
        f2.writeInt(i2);
    }

    public static void writeUnsignedLong(RandomAccessFile f2, @Unsigned long l2) throws IOException {
        f2.writeLong(l2);
    }

    public static void getUnsigned(ByteBuffer b2, @Unsigned byte[] bs) {
        b2.get(bs);
    }

    public static int compareUnsigned(@Unsigned short x2, @Unsigned short y2) {
        return Integer.compareUnsigned(Short.toUnsignedInt(x2), Short.toUnsignedInt(y2));
    }

    public static int compareUnsigned(@Unsigned byte x2, @Unsigned byte y2) {
        return Integer.compareUnsigned(Byte.toUnsignedInt(x2), Byte.toUnsignedInt(y2));
    }

    public static String toUnsignedString(@Unsigned short s2) {
        return Long.toString(Short.toUnsignedLong(s2));
    }

    public static String toUnsignedString(@Unsigned short s2, int radix) {
        return Integer.toUnsignedString(Short.toUnsignedInt(s2), radix);
    }

    public static String toUnsignedString(@Unsigned byte b2) {
        return Integer.toUnsignedString(Byte.toUnsignedInt(b2));
    }

    public static String toUnsignedString(@Unsigned byte b2, int radix) {
        return Integer.toUnsignedString(Byte.toUnsignedInt(b2), radix);
    }

    private static @Unsigned BigInteger toUnsignedBigInteger(@Unsigned long l2) {
        if (l2 >= 0L) {
            return BigInteger.valueOf(l2);
        }
        int upper = (int)(l2 >>> 32);
        int lower = (int)l2;
        return BigInteger.valueOf(Integer.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(Integer.toUnsignedLong(lower)));
    }

    public static @Unsigned short toUnsignedShort(@Unsigned byte b2) {
        return (short)(b2 & 0xFF);
    }

    public static @Unsigned long toUnsignedLong(@Unsigned char c2) {
        return (long)c2 & 0xFFL;
    }

    public static @Unsigned int toUnsignedInt(@Unsigned char c2) {
        return c2 & 0xFF;
    }

    public static @Unsigned short toUnsignedShort(@Unsigned char c2) {
        return (short)(c2 & 0xFF);
    }

    public static float toFloat(@Unsigned byte b2) {
        return SignednessUtil.toUnsignedBigInteger(Byte.toUnsignedLong(b2)).floatValue();
    }

    public static float toFloat(@Unsigned short s2) {
        return SignednessUtil.toUnsignedBigInteger(Short.toUnsignedLong(s2)).floatValue();
    }

    public static float toFloat(@Unsigned int i2) {
        return SignednessUtil.toUnsignedBigInteger(Integer.toUnsignedLong(i2)).floatValue();
    }

    public static float toFloat(@Unsigned long l2) {
        return SignednessUtil.toUnsignedBigInteger(l2).floatValue();
    }

    public static double toDouble(@Unsigned byte b2) {
        return SignednessUtil.toUnsignedBigInteger(Byte.toUnsignedLong(b2)).doubleValue();
    }

    public static double toDouble(@Unsigned short s2) {
        return SignednessUtil.toUnsignedBigInteger(Short.toUnsignedLong(s2)).doubleValue();
    }

    public static double toDouble(@Unsigned int i2) {
        return SignednessUtil.toUnsignedBigInteger(Integer.toUnsignedLong(i2)).doubleValue();
    }

    public static double toDouble(@Unsigned long l2) {
        return SignednessUtil.toUnsignedBigInteger(l2).doubleValue();
    }

    public static @Unsigned byte byteFromFloat(float f2) {
        assert (f2 >= 0.0f);
        return (byte)f2;
    }

    public static @Unsigned short shortFromFloat(float f2) {
        assert (f2 >= 0.0f);
        return (short)f2;
    }

    public static @Unsigned int intFromFloat(float f2) {
        assert (f2 >= 0.0f);
        return (int)f2;
    }

    public static @Unsigned long longFromFloat(float f2) {
        assert (f2 >= 0.0f);
        return (long)f2;
    }

    public static @Unsigned byte byteFromDouble(double d2) {
        assert (d2 >= 0.0);
        return (byte)d2;
    }

    public static @Unsigned short shortFromDouble(double d2) {
        assert (d2 >= 0.0);
        return (short)d2;
    }

    public static @Unsigned int intFromDouble(double d2) {
        assert (d2 >= 0.0);
        return (int)d2;
    }

    public static @Unsigned long longFromDouble(double d2) {
        assert (d2 >= 0.0);
        return (long)d2;
    }
}

