#!/usr/bin/env bash

EXA_HOME=/opt/exabeam

function setup(){
	# Load custom exabeam home if defined
	CUSTOM_EXA_HOME=`grep "CustomExabeamHome" config/picasso.conf | sed s/.*CustomExabeamHome.*[=,:]//g | sed -e 's/\s*"//' -e 's/"\s*//'`
	[ ! -z "$CUSTOM_EXA_HOME" ] && EXA_HOME=$CUSTOM_EXA_HOME

	# Load version for docker tag
	PICASSO_VERSION=`grep "version" etc/picasso.manifest | sed -e 's/app version: //g'`

	# Cleanup config
	[ -d "config/.unparsed-conf" ] && rm -rf ./config/.unparsed-conf
	[ -d "config/.parsed-conf" ] && rm -rf ./config/.parsed-conf
	
	mkdir -p ./config/.unparsed-conf/custom
	mkdir -p ./config/.unparsed-conf/default
	mkdir -p ./config/.parsed-conf
}

function copyConfigs() {
	# Copy config files to a local directory '.unparsed-conf'
	EBD=$EXA_HOME/config/default/event_builder_default.conf
	if [ -f $EBD ]; then
		cp $EBD ./config/.unparsed-conf/default/
	else
		echo "Essential config file $EBD not found, is CustomExabeamHome set?"
		exit 1
	fi

	EB=$EXA_HOME/config/custom/event_builder.conf
	if [ -f $EB ]; then
		cp $EB ./config/.unparsed-conf/custom/
	else
		echo "Essential config file $EB not found, is CustomExabeamHome set?"
		exit 1
	fi

	CR=$EXA_HOME/config/custom/rules.conf
	if [ -f $CR ]; then
		cp $CR ./config/.unparsed-conf/custom/
	else
		echo "Essential config file $CR not found, is CustomExabeamHome set?"
		exit 1
	fi

	# Remove include statements from the rules files
	sed -i s/^.*include.*$//g config/.unparsed-conf/custom/rules.conf
}

### Main script starts here
setup

copyConfigs

## Load the picasso docker image
echo "Loading picasso docker image"
/usr/bin/docker load < image/picasso_image.tar.gz

## Run picasso
docker run --rm -v `pwd`:/picasso --network host picasso:$PICASSO_VERSION

## Unload the picasso docker image
echo "Removing picasso docker image"
/usr/bin/docker rmi -f picasso:$PICASSO_VERSION
